<?php
/*******************************************************************************
Copyright (c) 2022 Clear Admin Software Kft.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/


//tested with magento-2.4.6
//2024-07-14
//ezekbe a státuszokba (state mező) kerülteket tölti le
$state = "'complete', 'processing'";

$code_prefix = "";
$shipment_tax_percent = 27;

//Csatlakozas adatbazishoz
$config = include __DIR__ . '/../app/etc/env.php';

// Extract database settings
$dbHost = $config['db']['connection']['default']['host'];
$dbUser = $config['db']['connection']['default']['username'];
$dbPass = $config['db']['connection']['default']['password'];
$dbName = $config['db']['connection']['default']['dbname'];
$table_prefix = $config['db']['table_prefix'];

// Create the MySQL connection
$conn = mysqli_connect($dbHost, $dbUser, $dbPass, $dbName);

if(mysqli_connect_errno()){
	show_error("DB open: " . mysqli_connect_errno());
}

if(!mysqli_query($conn, 'SET CHARACTER SET utf8')){
	show_error("Unable to set character set. ".mysqli_error($conn));
}

$last_orderhead_timestamp = @$_GET['last_orderhead_timestamp'];
if(strlen($last_orderhead_timestamp)>10){
	list($year, $month, $day, $hour, $minute, $second) = preg_split('/\D/', $last_orderhead_timestamp);
	$last_orderhead_timestamp = "$year-$month-$day $hour:$minute:$second";
}else{
	$last_orderhead_timestamp = '1990-01-01 01:02:03';
}

$max_orders = (int) @$_GET['max_orders'];
if(!$max_orders){
	$max_orders = 30;
}

$order_table_name = $table_prefix."sales_order";

//oc_order_history tábla date_added mező értéke lesz az időbélyeg.

$q = "
	select distinct *
	from $order_table_name
	where 
		updated_at >= '$last_orderhead_timestamp'
		and state in ($state)
	order by updated_at
	limit $max_orders
";
	
$res = mysqli_query($conn, $q);
if(!$res){
	show_error("select order: [$q] " . mysqli_error($conn));
}

print '<'.'?xml version="1.0" encoding="UTF-8" ?'.'>' . "\n";

print "<!DOCTYPE ORDERS>\n";
print "<ORDERS>\n";

while($order_ary = mysqli_fetch_assoc($res)){
	show_order($order_ary);
}

?>
</ORDERS>
<?php



function show_order($order)
{
	global $table_prefix;
	global $code_prefix;
	global $shipment_tax_percent;
	
	$table_name = $table_prefix . "sales_order_item";
	$q = "select * from $table_name where order_id = $order[entity_id]";
	$items = db_get_records($q);
	
	$today_str = date('Y-m-d');
	$shipped_date_str = $today_str;
	//list($year, $month, $day) = preg_split('/\D/', $order['date_added']);
	//$shipped_date_str = "$year-$month-$day";

	$order = ary_escape_html($order);

	//címek
	$table_name = $table_prefix . "sales_order_address";
	$q = "select * from $table_name where parent_id = $order[entity_id]";
	$addresses = db_get_records($q);
	$billing_address = [];
	$shipping_address = [];
	foreach($addresses as $address){
		if($address['address_type'] == 'billing'){
			$billing_address = ary_escape_html($address);
		}else if($address['address_type'] == 'shipping'){
			$shipping_address = ary_escape_html($address);
		}
	}
	$partner_name = $billing_address['company'].'';
	if(!strlen($partner_name)){
		$partner_name = $billing_address['lastname'] .' '.$billing_address['firstname'];
	}
	if($partner_name == ' '){
		$partner_name = $order['customer_lastname'] . ' ' . $order['customer_firstname'];
	}
	$partner_mail_name = $shipping_address['company'].'';
	if(!strlen($partner_mail_name)){
		$partner_mail_name = $shipping_address['lastname'] .' '.$shipping_address['firstname'];
	}

	$is_company = strlen($billing_address['vat_id'].'');
	//Ha cég, akkor az adószámát is át kell adni ORDERHEAD_PARTNER_TAX_NO mezőben.

	//fizetési mód
	$table_name = $table_prefix . "sales_order_payment";
	$q = "select * from $table_name where parent_id = $order[entity_id]";
	$payment = ary_escape_html(db_get_record($q));

	$partner_code = $order['customer_id'] . '';
	if(!strlen($partner_code)){
		$partner_code = $order['customer_email'];
	}

	?>

		<ORDER>
			<ORDERHEAD_CODE><?php echo $code_prefix ?><?php echo $order['increment_id']?></ORDERHEAD_CODE>
			<ORDERHEAD_TIMESTAMP><?php echo $order['updated_at']?></ORDERHEAD_TIMESTAMP>

			<ORDERHEAD_PARTNER_CODE><?php echo $code_prefix ?><?php echo $partner_code?></ORDERHEAD_PARTNER_CODE>
			<ORDERHEAD_PARTNER_NAME><?php echo $partner_name ?></ORDERHEAD_PARTNER_NAME>
			<ORDERHEAD_PARTNER_ZIP><?php echo $billing_address['postcode']?></ORDERHEAD_PARTNER_ZIP>
			<ORDERHEAD_PARTNER_CITY><?php echo $billing_address['city']?></ORDERHEAD_PARTNER_CITY>
			<ORDERHEAD_PARTNER_ADDRESS><?php echo $billing_address['street']?></ORDERHEAD_PARTNER_ADDRESS>
			<?php if($is_company){?>
				<ORDERHEAD_PARTNER_TAX_NO_TYPE>3</ORDERHEAD_PARTNER_TAX_NO_TYPE>
				<ORDERHEAD_PARTNER_TAX_NO><?php echo $billing_address['vat_id'];?></ORDERHEAD_PARTNER_TAX_NO>
			<?php }else{ ?>
				<ORDERHEAD_PARTNER_TAX_NO_TYPE>1</ORDERHEAD_PARTNER_TAX_NO_TYPE>
			<?php } ?>

			<ORDERHEAD_PARTNER_MAIL_IS_SAME>0</ORDERHEAD_PARTNER_MAIL_IS_SAME>
			<ORDERHEAD_PARTNER_MAIL_NAME><?php echo $partner_mail_name ?></ORDERHEAD_PARTNER_MAIL_NAME>
			<ORDERHEAD_PARTNER_MAIL_ZIP><?php echo $shipping_address['postcode'] ?></ORDERHEAD_PARTNER_MAIL_ZIP>
			<ORDERHEAD_PARTNER_MAIL_CITY><?php echo $shipping_address['city'] ?></ORDERHEAD_PARTNER_MAIL_CITY>
			<ORDERHEAD_PARTNER_MAIL_ADDRESS><?php echo $shipping_address['street'] ?></ORDERHEAD_PARTNER_MAIL_ADDRESS>

			<ORDERHEAD_PARTNER_CONTACT_EMAIL><?php echo $order['customer_email']?></ORDERHEAD_PARTNER_CONTACT_EMAIL>
			<ORDERHEAD_PARTNER_CONTACT_NAME><?php echo $order['customer_lastname'].' '.$order['customer_firstname']?></ORDERHEAD_PARTNER_CONTACT_NAME>

			<ORDERHEAD_PAYMENTMETHOD_CODE><?php echo $code_prefix ?><?php echo $payment['method']?></ORDERHEAD_PAYMENTMETHOD_CODE>

			<ORDERHEAD_DATE_SHIPPED><?php echo $shipped_date_str?></ORDERHEAD_DATE_SHIPPED>
			<ORDERHEAD_DATE_PAYMENT_DUE><?php echo $today_str?></ORDERHEAD_DATE_PAYMENT_DUE>

			<ORDERHEAD_SUBJECT>Internetes vásárlás - megrendelés azonosítója: <?php echo $order['increment_id']?></ORDERHEAD_SUBJECT>

			<ORDERHEAD_VERIFIED>1</ORDERHEAD_VERIFIED>
			<?php
				//utánvételi díj (payment_surcharge_amount és payment_surcharge_description)
				if($order['payment_surcharge_amount']){
					$item = array();
					$item['product_id'] = $order['payment_surcharge_description'];
					$item['name'] = $order['payment_surcharge_description'];
					$item['original_price'] = $order['payment_surcharge_amount'];
					$item['price_incl_tax'] = $order['payment_surcharge_amount'];
					$item['tax_percent'] = $shipment_tax_percent;
					$item['qty_ordered'] = 1;
					$items[] = $item;
				}
				//szállítási költség
				if($order['shipping_description']){
					$item = array();
					$item['product_id'] = $order['shipping_description'];
					$item['name'] = $order['shipping_description'];
					$item['original_price'] = $order['shipping_amount'];
					$item['price_incl_tax'] = $order['shipping_amount'];
					$item['tax_percent'] = $shipment_tax_percent;
					$item['qty_ordered'] = 1;
					$items[] = $item;
				}
				//customfee
				if($order['customfee']){
					$item = array();
					$item['product_id'] = 'customfee';
					$item['name'] = 'Egyedi költség';
					$item['original_price'] = $order['customfee'];
					$item['price_incl_tax'] = $order['customfee'];
					$item['tax_percent'] = $shipment_tax_percent;
					$item['qty_ordered'] = 1;
					$items[] = $item;
				}
				show_orderitems($items);
			?>
		</ORDER>
	<?php
}

function show_orderitems($items)
{
	if(!$items)
		return;
	global $table_prefix;
	$table_name = $table_prefix . "order_product";
	global $code_prefix;
	
	$child_name_map = Array();
	foreach($items as $item){
		$parent_item_id = $item['parent_item_id'];
		if($parent_item_id){
			$child_name_map[$parent_item_id] = $item['name'];
		}
	}

	
	foreach($items as $item){
		//ha van parentje, akkor nem kell a számlára (csak a parent)
		if($item['parent_item_id'] != null) continue;

		$item = ary_escape_html($item);

		//ha egy child parentje, akkor a név a child-ból jön
		$item_id = $item['item_id'];
		if(array_key_exists($item_id, $child_name_map)){
			$item['name'] = $child_name_map[$item_id];
		}

		//mennyisegi egyseg
		$unit = 'db';
		$vat_percent = (float) $item['tax_percent'];
		$vat_code = $vat_percent;
		$discount_type = 0;
		$list_price_gross = $item['original_price'];
		$price_gross = $item['price_incl_tax'];
		if($list_price_gross != $price_gross){
			$discount_type = 2;
		}

		
		?>

			<ORDERITEM>
				<ORDERITEM_PRODUCT_CODE><?php echo $code_prefix ?><?php echo $item['product_id']?></ORDERITEM_PRODUCT_CODE>
				<ORDERITEM_NAME><?php echo $item['name'] ?></ORDERITEM_NAME>
				<ORDERITEM_PART_NO><?php echo @$item['sku'] ?></ORDERITEM_PART_NO>
				<ORDERITEM_UNIT><?php echo $unit ?></ORDERITEM_UNIT>

				<ORDERITEM_VAT_CODE><?php echo $code_prefix ?><?php echo $vat_code?></ORDERITEM_VAT_CODE>
				<ORDERITEM_VAT_PERCENT><?php echo $vat_percent?></ORDERITEM_VAT_PERCENT>
				<ORDERITEM_VAT_NAME><?php echo ($vat_percent).'%'?></ORDERITEM_VAT_NAME>

				<ORDERITEM_PRICE_IS_GROSS>1</ORDERITEM_PRICE_IS_GROSS>
				<ORDERITEM_LIST_PRICE><?php echo $list_price_gross ?></ORDERITEM_LIST_PRICE>
				<ORDERITEM_PRICE><?php echo $price_gross ?></ORDERITEM_PRICE>
				<ORDERITEM_DISCOUNT_TYPE><?php echo $discount_type ?></ORDERITEM_DISCOUNT_TYPE>
				
				<ORDERITEM_QTY><?php echo $item['qty_ordered']?></ORDERITEM_QTY>
			</ORDERITEM>
		<?php
	}
}

function show_error($error_str)
{
	echo($error_str);
	die();
}

function db_get_record($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res){
		show_error("db_get_record(): [$q] " . mysqli_error($conn));
	}
	return mysqli_fetch_assoc($res);
}

function db_get_records($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res){
		show_error("db_get_records [$q] " . mysqli_error($conn));
	}
	$ret_ary = array();
	while($ary = mysqli_fetch_assoc($res)){
		$ret_ary[] = $ary;
	}
	if(count($ret_ary)){
		return $ret_ary;
	}
	return FALSE;
}

function ary_escape_html($ary)
{
	$res = array();
	foreach($ary as $k => $v){
		if(!is_array($v)){
			$res[$k] = htmlspecialchars($v);
		}else{
			$res[$k] = $v;
		}
	}
	return $res;
}

?>
