<?php
/*******************************************************************************
Copyright (c) 2022 Clear Admin Software Kft.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/


//tested with opencart-2.3.0.2

//cég adószámaként jelenleg custom_field mezőt adja át order táblából

$vat_percent = 27;//ez most be van égetve, mert opencart nem tárolja el az ÁFA-kulcsot a rendelés tételénél, csak az értékét
$code_prefix = "OC-";

//Csatlakozas adatbazishoz
require_once(dirname(__FILE__).'/../admin/config.php');

$conn = mysqli_connect(DB_HOSTNAME, DB_USERNAME, DB_PASSWORD, DB_DATABASE);

if(mysqli_connect_errno()){
	show_error("DB open: " . mysqli_connect_errno());
}

if(!mysqli_query($conn, 'SET CHARACTER SET utf8')){
	show_error("Unable to set character set. ".mysqli_error($conn));
}

$last_orderhead_timestamp = @$_GET['last_orderhead_timestamp'];
if(strlen($last_orderhead_timestamp)>10){
	list($year, $month, $day, $hour, $minute, $second) = preg_split('/\D/', $last_orderhead_timestamp);
	$last_orderhead_timestamp = "$year-$month-$day $hour:$minute:$second";
}else{
	$last_orderhead_timestamp = '1990-01-01 01:02:03';
}

$max_orders = (int) @$_GET['max_orders'];
if(!$max_orders){
	$max_orders = 30;
}

$table_prefix = DB_PREFIX;
$table_name = $table_prefix."order";	

//oc_order_history tábla date_added mező értéke lesz az időbélyeg.

$q = "
	select distinct *
	from $table_name
	where 
		date_added >= '$last_orderhead_timestamp'
	order by date_added limit $max_orders
";
	
$res = mysqli_query($conn, $q);
if(!$res){
	show_error("select order: [$q] " . mysqli_error($conn));
}

print '<'.'?xml version="1.0" encoding="UTF-8" standalone="yes" ?'.'>' . "\n";

print "<!DOCTYPE ORDERS>\n";
print "<ORDERS>\n";

while($order_ary = mysqli_fetch_assoc($res)){
	show_order($order_ary);
}

?>
</ORDERS>
<?php



function show_order($order)
{
	global $vat_percent;
	global $table_prefix;
	global $code_prefix;
	
	$table_name = $table_prefix . "order_product";
	$q = "select * from $table_name where order_id = $order[order_id]";
	$items = db_get_records($q);
	
	$today_str = date('Y-m-d');
	//$shipped_date_str = $today_str;
	list($year, $month, $day) = preg_split('/\D/', $order['date_added']);
	$shipped_date_str = "$year-$month-$day";

	$order = ary_escape_html($order);
	$is_company = strlen($order['payment_company']);
	//Ha cég, akkor az adószámát is át kell adni ORDERHEAD_PARTNER_TAX_NO mezőben.
	//Jelenleg custom_field mezőt adja át order táblából.
	//Ezt lejjebb a kódban módosítsuk a megfelelő mezőre, ha módosított OpenCartot használunk.

	?>

		<ORDER>
			<ORDERHEAD_CODE><?php echo $code_prefix ?><?php echo $order['order_id']?></ORDERHEAD_CODE>
			<ORDERHEAD_TIMESTAMP><?php echo $order['date_added']?></ORDERHEAD_TIMESTAMP>

			<ORDERHEAD_PARTNER_CODE><?php echo $code_prefix ?><?php echo $order['customer_id']?></ORDERHEAD_PARTNER_CODE>
			<ORDERHEAD_PARTNER_NAME><?php echo $is_company ? $order['payment_company'] : $order['payment_lastname'].' '.$order['payment_firstname']?></ORDERHEAD_PARTNER_NAME>
			<ORDERHEAD_PARTNER_ZIP><?php echo $order['payment_postcode']?></ORDERHEAD_PARTNER_ZIP>
			<ORDERHEAD_PARTNER_CITY><?php echo $order['payment_city']?></ORDERHEAD_PARTNER_CITY>
			<ORDERHEAD_PARTNER_ADDRESS><?php echo $order['payment_address_1'].' '.$order['payment_address_2']?></ORDERHEAD_PARTNER_ADDRESS>
			<?php if($is_company){?>
				<ORDERHEAD_PARTNER_TAX_NO_TYPE>3</ORDERHEAD_PARTNER_TAX_NO_TYPE>
				<ORDERHEAD_PARTNER_TAX_NO><?php echo $order['custom_field'];?></ORDERHEAD_PARTNER_TAX_NO>
			<?php }else{ ?>
				<ORDERHEAD_PARTNER_TAX_NO_TYPE>1</ORDERHEAD_PARTNER_TAX_NO_TYPE>
			<?php } ?>

			<ORDERHEAD_PARTNER_MAIL_IS_SAME>0</ORDERHEAD_PARTNER_MAIL_IS_SAME>
			<ORDERHEAD_PARTNER_MAIL_NAME><?php echo strlen($order['shipping_company']) ? $order['shipping_company'] : $order['shipping_lastname'].' '.$order['shipping_firstname'] ?></ORDERHEAD_PARTNER_MAIL_NAME>
			<ORDERHEAD_PARTNER_MAIL_ZIP><?php echo $order['shipping_postcode'] ?></ORDERHEAD_PARTNER_MAIL_ZIP>
			<ORDERHEAD_PARTNER_MAIL_CITY><?php echo $order['shipping_city'] ?></ORDERHEAD_PARTNER_MAIL_CITY>
			<ORDERHEAD_PARTNER_MAIL_ADDRESS><?php echo $order['shipping_address_1'].' '.$order['shipping_address_2'] ?></ORDERHEAD_PARTNER_MAIL_ADDRESS>

			<ORDERHEAD_PARTNER_CONTACT_EMAIL><?php echo $order['email']?></ORDERHEAD_PARTNER_CONTACT_EMAIL>
			<ORDERHEAD_PARTNER_CONTACT_NAME><?php echo $order['payment_lastname'].' '.$order['payment_firstname']?></ORDERHEAD_PARTNER_CONTACT_NAME>

			<ORDERHEAD_PAYMENTMETHOD_CODE><?php echo $code_prefix ?><?php echo $order['payment_code']?></ORDERHEAD_PAYMENTMETHOD_CODE>
			<ORDERHEAD_PAYMENTMETHOD_NAME><?php echo $order['payment_method']?></ORDERHEAD_PAYMENTMETHOD_NAME>

			<ORDERHEAD_DATE_SHIPPED><?php echo $shipped_date_str?></ORDERHEAD_DATE_SHIPPED>
			<ORDERHEAD_DATE_PAYMENT_DUE><?php echo $today_str?></ORDERHEAD_DATE_PAYMENT_DUE>

			<ORDERHEAD_SUBJECT>Internetes vásárlás - megrendelés azonosítója: <?php echo $order['order_id']?></ORDERHEAD_SUBJECT>

			<ORDERHEAD_VERIFIED>1</ORDERHEAD_VERIFIED>
			<?php
			//szallitasi ktg egy plusz tetel legyen order_total-bol
				$table_name = $table_prefix . "order_total";
				$shipping_rec = db_get_record("select * from $table_name where order_id = $order[order_id] and code = 'shipping'");
				if($shipping_rec && $shipping_rec['value']){
					$item = array(
						'order_product_id' => $order['order_id'].'_sztg',
						'product_id' => 'sztg',
						'name' => $shipping_rec['title'],
						'product_tax' => $vat_percent,
						//'price' => $shipping_rec['value'],
						'price' => round($shipping_rec['value'] / ((100 + $vat_percent)/100), 2),
						'quantity' => 1,
					);
					$items[] = $item;
				}
				
				show_orderitems($items);
				
			?>

		</ORDER>
	<?php
}

function show_orderitems($items)
{
	if(!$items)
		return;
	global $unit_map;
	global $statno_map;
	global $vat_percent;
	global $table_prefix;
	$table_name = $table_prefix . "order_product";
	global $code_prefix;
	
	foreach($items as $item){
		$item = ary_escape_html($item);

		//mennyisegi egyseg
		$unit = 'db';
		$vat_code = $vat_percent;
		//$price = $item['item_amt'] * 100 / (100+$vat_percent);
		if('sztg' === $item['product_id']){
			$unit = ' ';
		}

		//statisztikai szamjel (VTSZ/SZJ)
		$statno = '';
		if('sztg' === $item['product_id']){
			$statno = ''; //Ha akarunk SZJ-t szallitasi ktg-hez
		}elseif('engedmeny' === $item['product_id']){
			$statno = ''; //Ha akarunk SZJ-t engedményhez
		}
		$comment_str = $item['product_id'];
		
		?>

			<ORDERITEM>
				<ORDERITEM_CODE><?php echo $code_prefix ?><?php echo $item['order_product_id']?></ORDERITEM_CODE>

				<ORDERITEM_PRODUCT_CODE><?php echo $code_prefix ?><?php echo $item['product_id']?></ORDERITEM_PRODUCT_CODE>
				<ORDERITEM_STAT_NO><?php echo  $statno ?></ORDERITEM_STAT_NO>
				<ORDERITEM_NAME><?php echo strip_tags($item['name'])?></ORDERITEM_NAME>
				<ORDERITEM_COMMENT><?php echo $comment_str ?></ORDERITEM_COMMENT>
				<ORDERITEM_UNIT><?php echo $unit?></ORDERITEM_UNIT>
				<ORDERITEM_VAT_CODE><?php echo $code_prefix ?><?php echo $vat_code?></ORDERITEM_VAT_CODE>
				<ORDERITEM_VAT_PERCENT><?php echo $vat_percent?></ORDERITEM_VAT_PERCENT>
				<ORDERITEM_VAT_NAME><?php echo ((float) $vat_percent).'%'?></ORDERITEM_VAT_NAME>

				<ORDERITEM_LIST_PRICE><?php echo $item['price']?></ORDERITEM_LIST_PRICE>
				
				<ORDERITEM_QTY><?php echo $item['quantity']?></ORDERITEM_QTY>
			</ORDERITEM>
		<?php
	}
}

function show_error($error_str)
{
	echo($error_str);
	die();
}

function db_get_record($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res){
		show_error("db_get_record(): [$q] " . mysqli_error($conn));
	}
	return mysqli_fetch_assoc($res);
}

function db_get_records($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res){
		show_error("db_get_records [$q] " . mysqli_error($conn));
	}
	$ret_ary = array();
	while($ary = mysqli_fetch_assoc($res)){
		$ret_ary[] = $ary;
	}
	if(count($ret_ary)){
		return $ret_ary;
	}
	return FALSE;
}

function ary_escape_html($ary)
{
	$res = array();
	foreach($ary as $k => $v){
		if(!is_array($v)){
			$res[$k] = htmlspecialchars($v);
		}else{
			$res[$k] = $v;
		}
	}
	return $res;
}

?>
