<?php

/*******************************************************************************
Copyright (c) 2013 Clear Admin Software Kft.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

//tesztelve: prestashop_1.3.0.3
// ilyen statuszuak kerulnek a szamlazo programba:
$state_to_download = 3;

// szállítási költség ÁFÁ-ja (%):
$sztg_afa = 27;

//Csatlakozas adatbazishoz
require_once(dirname(__FILE__).'/../config/settings.inc.php');


if(!mysql_connect(_DB_SERVER_, _DB_USER_, _DB_PASSWD_))
{
	show_error("DB open: " . mysql_error());
}
if(!mysql_select_db(_DB_NAME_))
{
	show_error("DB select: " . mysql_error());
}

//if(!mysql_query('SET NAMES utf-8'))
if(!mysql_query('SET CHARACTER SET utf8'))
{
	show_error("Unable to set character set. ".mysql_error());
}


$last_orderhead_timestamp = (int) @$_GET['last_orderhead_timestamp'];
$max_orders = (int) @$_GET['max_orders'];

if(!$max_orders)
	$max_orders = 30;

$table_prefix = _DB_PREFIX_;

	
$orders_table_name = $table_prefix . "orders";
$history_table_name = $table_prefix . "order_history";
$q = "select distinct *, $history_table_name.date_add state_changed_date
	from
		$history_table_name, $orders_table_name
	where
		$history_table_name.date_add >= $last_orderhead_timestamp
		and
		$history_table_name.id_order_state = $state_to_download
		and
		$orders_table_name.id_order = $history_table_name.id_order
		and
		$orders_table_name.valid = 1
	order by $history_table_name.date_add limit $max_orders";

$res = mysql_query($q);
if(!$res)
	show_error("select order: [$q] " . mysql_error());

//print '<'.'?xml version="1.0" encoding="UTF-8" standalone="yes" ?'.'>' . "\n";

print "<!DOCTYPE ORDERS>\n";
print "<ORDERS>\n";

while($order_ary = mysql_fetch_assoc($res))
{
	show_order($order_ary);
}

?>
</ORDERS>
<?php



function show_order($order)
{

	global $table_prefix;
	global $sztg_afa;
	$table_name = $table_prefix . "order_detail";
	$q = "select * from $table_name where id_order = '$order[id_order]'";
	$items = db_get_records($q);

	$today_str = date('Y-m-d');
	$shipped_date_str = $today_str; 

	//cimek:
	//szamlazasi cim
	$table_name = $table_prefix . "address";
	$q = "select * from $table_name where id_address = '$order[id_address_invoice]'";
	$address_invoice = db_get_record($q);
	//postacim
	if($order['id_address_invoice'] == $order['id_address_delivery']){
		$address_delivery = $address_invoice;
	}else{
		$table_name = $table_prefix . "address";
		$q = "select * from $table_name where id_address = '$order[id_address_delivery]'";
		$address_delivery = db_get_record($q);
	}
	


	?>

		<ORDER>
			<ORDERHEAD_CODE><?php echo $order['id_order']?></ORDERHEAD_CODE>
			<ORDERHEAD_TIMESTAMP><?php echo $order['state_changed_date']?></ORDERHEAD_TIMESTAMP>

			<ORDERHEAD_PARTNER_CODE><?php echo he($order['id_customer'])?></ORDERHEAD_PARTNER_CODE>
			<ORDERHEAD_PARTNER_NAME><?php echo he(strlen($address_invoice['company']) ? $address_invoice['company'] : $address_invoice['lastname'].' '.$address_invoice['firstname'])?></ORDERHEAD_PARTNER_NAME>
			<ORDERHEAD_PARTNER_ZIP><?php echo he($address_invoice['postcode'])?></ORDERHEAD_PARTNER_ZIP>
			<ORDERHEAD_PARTNER_CITY><?php echo he($address_invoice['city'])?></ORDERHEAD_PARTNER_CITY>
			<ORDERHEAD_PARTNER_ADDRESS><?php echo he($address_invoice['address1'].' '.$address_invoice['address2'])?></ORDERHEAD_PARTNER_ADDRESS>

			<ORDERHEAD_PARTNER_MAIL_IS_SAME><?php echo  $order['id_address_invoice'] == $order['id_address_delivery'] ? "1" : "0" ?></ORDERHEAD_PARTNER_MAIL_IS_SAME>

			<ORDERHEAD_PARTNER_MAIL_NAME><?php echo he(strlen($address_delivery['company']) ? $address_delivery['company'] : $address_delivery['lastname'].' '.$address_delivery['firstname'])?></ORDERHEAD_PARTNER_MAIL_NAME>
			<ORDERHEAD_PARTNER_MAIL_ZIP><?php echo he($address_delivery['postcode'])?></ORDERHEAD_PARTNER_MAIL_ZIP>
			<ORDERHEAD_PARTNER_MAIL_CITY><?php echo he($address_delivery['city'])?></ORDERHEAD_PARTNER_MAIL_CITY>
			<ORDERHEAD_PARTNER_MAIL_ADDRESS><?php echo he($address_delivery['address1'].' '.$address_delivery['address2'])?></ORDERHEAD_PARTNER_MAIL_ADDRESS>

			<ORDERHEAD_PAYMENTMETHOD_CODE><?php echo $order['payment']?></ORDERHEAD_PAYMENTMETHOD_CODE>
			<ORDERHEAD_PAYMENTMETHOD_NAME><?php echo $order['payment']?></ORDERHEAD_PAYMENTMETHOD_NAME>

			<ORDERHEAD_DATE_SHIPPED><?php echo $shipped_date_str?></ORDERHEAD_DATE_SHIPPED>
			<ORDERHEAD_DATE_PAYMENT_DUE><?php echo $today_str?></ORDERHEAD_DATE_PAYMENT_DUE>

			<ORDERHEAD_SUBJECT>Internetes vásárlás - megrendelés azonosítója: <?php echo $order['id_order']?></ORDERHEAD_SUBJECT>

			<ORDERHEAD_VERIFIED>1</ORDERHEAD_VERIFIED>
			<?php
				//szallitasi ktg egy plusz tetel legyen
				if($order['total_shipping']>0.0){
					$item = array(
						'id_order_detail' => $order['id_order'].'_sztg',
						'product_id' => 'sztg',
						'product_name' => 'Szállítási költség',
						'product_price' => $order['total_shipping']*100/(100+$sztg_afa),
						'product_quantity' => 1,
					);
					$items[] = $item;
				}
				
				show_orderitems($items);
				
			?>

		</ORDER>
	<?php
}

function show_orderitems($items)
{
	global $table_prefix;
	global $sztg_afa;
	if(!$items)
		return;
	foreach($items as $item)
	{
		
		$comment_str = '';

		//statisztikai szamjel (VTSZ/SZJ)
		$statno = '';
		$comment_str = '';
		$unit = 'db';
		if('sztg' === $item['product_id']){
			$unit = '';
			$item['tax_rate'] = $sztg_afa;
			$item['tax_name'] = $sztg_afa.'%';
		}
		
		?>

			<ORDERITEM>
				<ORDERITEM_CODE><?php echo $item['id_order_detail']?></ORDERITEM_CODE>

				<ORDERITEM_PRODUCT_CODE><?php echo $item['product_id']?></ORDERITEM_PRODUCT_CODE>
				<ORDERITEM_STAT_NO><?php echo  $statno ?></ORDERITEM_STAT_NO>
				<ORDERITEM_NAME><?php echo $item['product_name']?></ORDERITEM_NAME>
				<ORDERITEM_COMMENT><?php echo $comment_str?></ORDERITEM_COMMENT>
				<ORDERITEM_UNIT><?php echo $unit?></ORDERITEM_UNIT>
				<ORDERITEM_VAT_CODE><?php echo $item['tax_name']?></ORDERITEM_VAT_CODE>
				<ORDERITEM_VAT_PERCENT><?php echo $item['tax_rate']?></ORDERITEM_VAT_PERCENT>
				<ORDERITEM_VAT_NAME><?php echo $item['tax_name']?></ORDERITEM_VAT_NAME>

				<ORDERITEM_PRICE><?php echo $item['product_price']?></ORDERITEM_PRICE>
				<ORDERITEM_QTY><?php echo $item['product_quantity']?></ORDERITEM_QTY>
			</ORDERITEM>
		<?php
	}
}


function he($s)
{
	//return htmlentities($s);
	return $s;
}

function show_error($error_str)
{
	echo($error_str);
	die();
}

function db_get_record($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_record(): [$q] " . mysql_error());
	return mysql_fetch_assoc($res);
}

function db_get_field($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_field(): [$q] " . mysql_error());
	$row = mysql_fetch_row($res);
	if($row == FALSE) return FALSE;
	return $row[0];
}

function db_get_records($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_records [$q] " . mysql_error());
	$ret_ary = array();
	while($ary = mysql_fetch_assoc($res))
	{
		$ret_ary[] = $ary;
	}
	if(count($ret_ary))
		return $ret_ary;
	return FALSE;
}

function db_get_map($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_map [$q] " . mysql_error());
	$ret_ary = array();
	while($ary = mysql_fetch_row($res))
	{
		$ret_ary[$ary[0]] = $ary[1];
	}
	if(count($ret_ary))
		return $ret_ary;
	return FALSE;
}

function ary_to_utf8($ary)
{
	$res = array();
	foreach($ary as $k => $v)
	{
		if(!is_array($v))
		{
			$res[$k] = mb_convert_encoding($v, 'UTF-8', 'ISO-8859-2');
		}
		else
		{
			$res[$k] = $v;
		}
	}
	return $res;
}

?>
