<?php
/*******************************************************************************
Copyright (c) 2013, 2024 Zsolt Debre, Jonathan Till, Attila Alapi.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/


//Ezt a PHP fájlt abba a mappába kell másolni, ahol a Joomla configuration.php fájlja van.
//Így az elérése: https://az-on-webshopja.hu/clearadmin_orders_virtuemart4.php
//Célszerű a fájlt úgy átnevezni, hogy ne lehessen kitalálni a nevét vagy
//jelszóvédetté tenni (pl.: .htaccess és .htpasswd beállításával)
//Virtuemart 4-hez készült.

$vatcode = 'AFA_KULCS';//csak a kódot adjuk meg, hogy azt válasszon, amit akar


//csatlakozas adatbazishoz
require_once(dirname(__FILE__).'/configuration.php');

//Rendelések státusza
//$order_complete_status = 'C'; //C = Confirmed

$config = new JConfig;

$conn = mysqli_connect($config->host, $config->user, $config->password);

/* check connection */
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}


if(!mysqli_select_db($conn, $config->db))
{
	show_error("DB select: " . mysqli_error($conn));
}

//if(!mysqli_query($conn, 'SET NAMES utf-8'))
if(!mysqli_query($conn, 'SET CHARACTER SET utf8'))
{
	show_error("Unable to set character set. ".mysqli_error($conn));
}


$last_orderhead_timestamp = (int) @$_GET['last_orderhead_timestamp'];

$max_orders = (int) @$_GET['max_orders'];
if(!$max_orders){
	$max_orders = 100;
}

//fizetesi modok egy tombbe (map)
$table_name = $config->dbprefix . "virtuemart_paymentmethods_hu_hu"; 
$q = "select * from $table_name";
$payment_method_map = db_get_map($q);


//szállítási modok egy tombbe (map)
$table_name = $config->dbprefix . "virtuemart_shipmentmethods_hu_hu";
$q = "select virtuemart_shipmentmethod_id, shipment_name from $table_name ";
$shipment_method_map = db_get_map($q);


$table_name = $config->dbprefix . "virtuemart_orders";
$second_table_name = $config->dbprefix . "virtuemart_currencies";
$q = "select * from $table_name as ORD ";
$q .= "left join $second_table_name as CCY on ORD.order_currency = CCY.virtuemart_currency_id ";
//$q .= "where order_status ='$order_complete_status' and virtuemart_order_id > ". ($last_orderhead_timestamp) ." order by virtuemart_order_id limit $max_orders";
$q .= "where virtuemart_order_id > ". ($last_orderhead_timestamp) ." order by virtuemart_order_id limit $max_orders";

$res = mysqli_query($conn, $q);
if(!$res)
	show_error("select order: [$q] " . mysqli_error($conn));


echo '<'.'?xml version="1.0" encoding="UTF-8" standalone="yes" ?'.'>' . "\n";

echo '<!DOCTYPE ORDERS>';
echo '<ORDERS>';

while($order_ary = mysqli_fetch_assoc($res))
{
	show_order($order_ary);
}

echo '</ORDERS>';

function show_order($order)
{
	global $vatcode;
	global $config;
	global $payment_method_map;
    global $shipment_method_map;

	$orderid = $order['virtuemart_order_id'];
	
	$table_name = $config->dbprefix . "virtuemart_order_userinfos";
	$second_table_name = $config->dbprefix . "virtuemart_countries";
	$third_table_name = $config->dbprefix . "users";
	$q = "select * from $table_name as USER ";
	$q .= "left join $second_table_name as CTRY on USER.virtuemart_country_id = CTRY.virtuemart_country_id ";
	$q .= "where virtuemart_order_id = $orderid and address_type='BT'";
	
	$user = db_get_record($q);

	//szállítási címek
	$table_name = $config->dbprefix . "virtuemart_order_userinfos";
	$second_table_name = $config->dbprefix . "virtuemart_countries";
	$third_table_name = $config->dbprefix . "users";
	$q = "select * from $table_name as USER ";
	$q .= "left join $second_table_name as CTRY on USER.virtuemart_country_id = CTRY.virtuemart_country_id ";
	$q .= "where virtuemart_order_id = $orderid and address_type='ST'";
	
	$user_shipping = db_get_record($q);
	
	$table_name = $config->dbprefix . "virtuemart_order_items";
	$q = "select * from $table_name where virtuemart_order_id = $orderid";
	$items = db_get_records($q);

	$today_str = date('Y-m-d');
	$shipped_date_str = $today_str;

	//fizetesi és szállítási mod
    $payment_method_name = $payment_method_map[$order['virtuemart_paymentmethod_id']];
    $shipment_method_name = $shipment_method_map[$order['virtuemart_shipmentmethod_id']];
	
	
	?>

		<ORDER>
			<ORDERHEAD_CODE><?php echo $order['virtuemart_order_id'].'-'.$order['order_number']; ?></ORDERHEAD_CODE>
			<ORDERHEAD_TIMESTAMP><?php echo sprintf("%010d", $order['virtuemart_order_id']); ?></ORDERHEAD_TIMESTAMP>
			<ORDERHEAD_PARTNER_CODE><?php echo $order['customer_number']; ?></ORDERHEAD_PARTNER_CODE>
			<ORDERHEAD_PARTNER_NAME><?php echo he(strlen($user['company']) ? $user['company'] : $user['last_name'].' '.$user['first_name']); ?></ORDERHEAD_PARTNER_NAME>
			<ORDERHEAD_PARTNER_ZIP><?php echo he($user['zip']); ?></ORDERHEAD_PARTNER_ZIP>
			<ORDERHEAD_PARTNER_CITY><?php echo he($user['city']); ?></ORDERHEAD_PARTNER_CITY>
			<ORDERHEAD_PARTNER_ADDRESS><?php echo he($user['address_1'].' '.$user['address_2']); ?></ORDERHEAD_PARTNER_ADDRESS>
			<ORDERHEAD_PARTNER_TAX_NO><?php if (array_key_exists("adoszam",$user)) { echo $user['adoszam']; } ?></ORDERHEAD_PARTNER_TAX_NO>
			<ORDERHEAD_PARTNER_EU_TAX_NO><?php if (array_key_exists("euadoszam",$user)) { echo $user['euadoszam']; } ?></ORDERHEAD_PARTNER_EU_TAX_NO>
			<ORDERHEAD_PARTNER_COUNTRY_INTERNATIONAL_CODE><?php echo $user['country_2_code']; ?></ORDERHEAD_PARTNER_COUNTRY_INTERNATIONAL_CODE>
			<ORDERHEAD_PARTNER_OTHER_DATA></ORDERHEAD_PARTNER_OTHER_DATA>
			
			<ORDERHEAD_PARTNER_MAIL_IS_SAME><?php echo he(strlen($user_shipping['address_type']) ? 0 : 1); ?></ORDERHEAD_PARTNER_MAIL_IS_SAME>
			<ORDERHEAD_PARTNER_MAIL_NAME><?php echo he(strlen($user_shipping['company']) ? $user_shipping['company'] : $user_shipping['last_name'].' '.$user_shipping['first_name']); ?></ORDERHEAD_PARTNER_MAIL_NAME>
			<ORDERHEAD_PARTNER_MAIL_ZIP><?php echo he($user_shipping['zip']); ?></ORDERHEAD_PARTNER_MAIL_ZIP>
			<ORDERHEAD_PARTNER_MAIL_CITY><?php echo he($user_shipping['city']); ?></ORDERHEAD_PARTNER_MAIL_CITY>
			<ORDERHEAD_PARTNER_MAIL_ADDRESS><?php echo he($user_shipping['address_1'].' '.$user_shipping['address_2']); ?></ORDERHEAD_PARTNER_MAIL_ADDRESS>
			<ORDERHEAD_PARTNER_MAIL_COUNTRY_INTERNATIONAL_CODE><?php echo $user_shipping['country_2_code']; ?></ORDERHEAD_PARTNER_MAIL_COUNTRY_INTERNATIONAL_CODE>
			
			<ORDERHEAD_PARTNER_CONTACT_EMAIL><?php echo he($user['email']); ?></ORDERHEAD_PARTNER_CONTACT_EMAIL>
			
			<ORDERHEAD_PAYMENTMETHOD_CODE><?php echo he($payment_method_name); ?></ORDERHEAD_PAYMENTMETHOD_CODE>
			<ORDERHEAD_PAYMENTMETHOD_NAME><?php echo he($payment_method_name); ?></ORDERHEAD_PAYMENTMETHOD_NAME>
			<ORDERHEAD_DATE_SHIPPED><?php echo $shipped_date_str; ?></ORDERHEAD_DATE_SHIPPED>
			<ORDERHEAD_DATE_PAYMENT_DUE><?php echo $today_str; ?></ORDERHEAD_DATE_PAYMENT_DUE>
			<ORDERHEAD_NO_VAT></ORDERHEAD_NO_VAT>
			<ORDERHEAD_NOVATREASON_CODE></ORDERHEAD_NOVATREASON_CODE>
			<ORDERHEAD_CURRENCY_ABBREVIATION><?php echo $order['currency_code_3']; ?></ORDERHEAD_CURRENCY_ABBREVIATION>
			<ORDERHEAD_SUBJECT>Internetes vásárlás: <?php echo $order['order_number']; ?></ORDERHEAD_SUBJECT>
			<ORDERHEAD_VERIFIED>1</ORDERHEAD_VERIFIED>

<?php
			show_orderitems($items,$order);

			//add item for shipping too if present
			$grossshipping = $order['order_shipment']+$order['order_shipment_tax'];
			if($grossshipping > 2.5) {
?>
				<ORDERITEM>
					<ORDERITEM_NAME><?php echo he('Szállítási költség - '.$shipment_method_name) ?></ORDERITEM_NAME>
					<ORDERITEM_PRODUCT_CODE>vmszktg</ORDERITEM_PRODUCT_CODE>
					<ORDERITEM_QTY>1</ORDERITEM_QTY>
					<ORDERITEM_UNIT></ORDERITEM_UNIT>
					<ORDERITEM_PRICE_IS_GROSS>1</ORDERITEM_PRICE_IS_GROSS>
					<ORDERITEM_LIST_PRICE><?php echo $order['order_shipment'] ?></ORDERITEM_LIST_PRICE>
					<ORDERITEM_PRICE><?php echo $order['order_shipment'] ?></ORDERITEM_PRICE>
					<ORDERITEM_VAT_CODE><?php echo $vatcode; ?></ORDERITEM_VAT_CODE>
				</ORDERITEM>

<?php
			}

?>

		</ORDER>
<?php
}

function show_orderitems($items,$order)
{
	global $vatcode;
	foreach($items as $item) {
		$unit = '';
		$name = $item['order_item_name'];
		$code = $item['virtuemart_product_id'];
		if ($code !== 'szktg'){
			$unit = 'db';
		}
		$price = $item['product_discountedPriceWithoutTax'];
?>
			<ORDERITEM>
				<ORDERITEM_NAME><?php echo he($name); ?></ORDERITEM_NAME>
				<ORDERITEM_PRODUCT_CODE><?php echo 'vm'.$code ?></ORDERITEM_PRODUCT_CODE>
				<ORDERITEM_PART_NO><?php echo he($item['order_item_sku'])?></ORDERITEM_PART_NO>
				<ORDERITEM_QTY><?php echo $item['product_quantity']; ?></ORDERITEM_QTY>
				<ORDERITEM_UNIT><?php echo $unit; ?></ORDERITEM_UNIT>
				<ORDERITEM_LIST_PRICE><?php echo $price ?></ORDERITEM_LIST_PRICE>
				<ORDERITEM_PRICE><?php echo $price ?></ORDERITEM_PRICE>
				<ORDERITEM_VAT_CODE><?php echo $vatcode; ?></ORDERITEM_VAT_CODE>
			</ORDERITEM>
<?php

				

	}
}


function he($s)
{
	return $s;//magic quotes esetén
	return htmlentities($s);
}

function show_error($error_str)
{
	echo($error_str);
	die();
}

function db_get_record($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res)
		show_error("db_get_record(): [$q] " . mysqli_error($conn));
	return mysqli_fetch_assoc($res);
}

function db_get_field($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res)
		show_error("db_get_field(): [$q] " . mysqli_error($conn));
	$row = mysqli_fetch_row($res);
	if($row == FALSE) return FALSE;
	return $row[0];
}

function db_get_records($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res)
		show_error("db_get_records [$q] " . mysqli_error($conn));
	$ret_ary = array();
	while($ary = mysqli_fetch_assoc($res))
	{
		$ret_ary[] = $ary;
	}
	if(count($ret_ary))
		return $ret_ary;
	return FALSE;
}

function db_get_map($q)
{
	global $conn;
	$res = mysqli_query($conn, $q);
	if(!$res)
		show_error("db_get_map [$q] " . mysqli_error($conn));
	$ret_ary = array();
	while($ary = mysqli_fetch_row($res))
	{
		$ret_ary[$ary[0]] = $ary[1];
	}
	if(count($ret_ary))
		return $ret_ary;
	return FALSE;
}

function ary_to_utf8($ary)
{
	$res = array();
	foreach($ary as $k => $v)
	{
		if(!is_array($v))
		{
			$res[$k] = mb_convert_encoding($v, 'UTF-8', 'ISO-8859-2');
		}
		else
		{
			$res[$k] = $v;
		}
	}
	return $res;
}

?>
 
