<?php
/*******************************************************************************
Copyright (c) 2013 Zsolt Debre, Attila Alapi.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

//tested with VM3.4.1 and JoomShopping 4.9.2

//csatlakozas adatbazishoz
require_once(dirname(__FILE__).'/../configuration.php');

$config = new JConfig;

if(!mysql_connect($config->host, $config->user, $config->password))
{
	show_error("DB open: " . mysql_error());
}
if(!mysql_select_db($config->db))
{
	show_error("DB select: " . mysql_error());
}

//if(!mysql_query('SET NAMES utf-8'))
if(!mysql_query('SET CHARACTER SET utf8'))
{
	show_error("Unable to set character set. ".mysql_error());
}


$last_orderhead_timestamp = (int) @$_GET['last_orderhead_timestamp'];
$max_orders = (int) @$_GET['max_orders'];
if(!$max_orders)
	$max_orders = 100;

//fizetesi modok egy tombbe (map)
$table_name = $config->dbprefix . "jshopping_payment_method";
$q = "select payment_id, payment_code from $table_name ";
$payment_method_map = db_get_map($q);

//szállítási modok egy tombbe (map)
$table_name = $config->dbprefix . "jshopping_shipping_method";
$q = "select shipping_id, `name_hu-HU` from $table_name ";
$shipment_method_map = db_get_map($q);
	
$table_name = $config->dbprefix . "jshopping_orders";
$q = "select * from $table_name as ORD ";
$q .= "where order_date >= ". ($last_orderhead_timestamp) ." order by order_id limit $max_orders";

$res = mysql_query($q);
if(!$res)
	show_error("select order: [$q] " . mysql_error());

	
echo '<'.'?xml version="2.0" encoding="UTF-8" standalone="yes" ?'.'>' . "\n";

echo '<!DOCTYPE ORDERS>';
echo '<ORDERS>';

while($order_ary = mysql_fetch_assoc($res))
{
	show_order($order_ary);
}

echo '</ORDERS>';

function show_order($order)
{
	global $config;
	global $payment_method_map;
    global $shipment_method_map;

	//$userid = $order['virtuemart_user_id'];
	$orderid = $order['order_id'];
	
	$table_name = $config->dbprefix . "jshopping_order_item";
	$q = "select * from $table_name where order_id = $orderid";
	$items = db_get_records($q);

	$today_str = date('Y-m-d');
	$shipped_date_str = $today_str;

	//fizetesi és szállítási mod
    $payment_method_name = $payment_method_map[$order['payment_method_id']];
    $shipment_method_name = $shipment_method_map[$order['shipping_method_id']];
	
	?>
		<ORDER>
			<ORDERHEAD_CODE><?php echo $order['order_id']; ?></ORDERHEAD_CODE>
			<ORDERHEAD_TIMESTAMP><?php echo he($order['order_date']); ?></ORDERHEAD_TIMESTAMP>
			<ORDERHEAD_PARTNER_CODE><?php echo $order['f_name'].'_'.$order['l_name'];  ?></ORDERHEAD_PARTNER_CODE>
			<ORDERHEAD_PARTNER_NAME><?php echo he(strlen($order['firma_name']) ? $order['firma_name'] : $order['l_name'].' '.$order['f_name']); ?></ORDERHEAD_PARTNER_NAME>
			<ORDERHEAD_PARTNER_ZIP><?php echo he($order['zip']); ?></ORDERHEAD_PARTNER_ZIP>
			<ORDERHEAD_PARTNER_CITY><?php echo he($order['city']); ?></ORDERHEAD_PARTNER_CITY>
			<ORDERHEAD_PARTNER_ADDRESS><?php echo he($order['street'].' '.$order['street_nr']); ?></ORDERHEAD_PARTNER_ADDRESS>
			<ORDERHEAD_PARTNER_TAX_NO><?php echo he($order['tax_number']); ?></ORDERHEAD_PARTNER_TAX_NO>
			<ORDERHEAD_PARTNER_OTHER_DATA></ORDERHEAD_PARTNER_OTHER_DATA>
			
			<ORDERHEAD_PARTNER_MAIL_IS_SAME><?php echo he(strlen($order['d_f_name']) ? 0 : 1); ?></ORDERHEAD_PARTNER_MAIL_IS_SAME>
			<ORDERHEAD_PARTNER_MAIL_NAME><?php echo he(strlen($order['d_firma_name']) ? $order['d_firma_name'] : $order['d_l_name'].' '.$order['d_f_name']); ?></ORDERHEAD_PARTNER_MAIL_NAME>
			<ORDERHEAD_PARTNER_MAIL_ZIP><?php echo he($order['d_zip']); ?></ORDERHEAD_PARTNER_MAIL_ZIP>
			<ORDERHEAD_PARTNER_MAIL_CITY><?php echo he($order['d_city']); ?></ORDERHEAD_PARTNER_MAIL_CITY>
			<ORDERHEAD_PARTNER_MAIL_ADDRESS><?php echo he($order['d_street'].' '.$order['d_street_nr']); ?></ORDERHEAD_PARTNER_MAIL_ADDRESS>
				
			
			<ORDERHEAD_PAYMENTMETHOD_CODE><?php echo he($payment_method_name); ?></ORDERHEAD_PAYMENTMETHOD_CODE>
			<ORDERHEAD_PAYMENTMETHOD_NAME><?php echo he($payment_method_name); ?></ORDERHEAD_PAYMENTMETHOD_NAME>
			<ORDERHEAD_DATE_SHIPPED><?php echo $shipped_date_str; ?></ORDERHEAD_DATE_SHIPPED>
			<ORDERHEAD_DATE_PAYMENT_DUE><?php echo $today_str; ?></ORDERHEAD_DATE_PAYMENT_DUE>
			<ORDERHEAD_NO_VAT></ORDERHEAD_NO_VAT>
			<ORDERHEAD_NOVATREASON_CODE></ORDERHEAD_NOVATREASON_CODE>
			<ORDERHEAD_CURRENCY_ABBREVIATION><?php echo $order['currency_code']; ?></ORDERHEAD_CURRENCY_ABBREVIATION>
			<ORDERHEAD_SUBJECT>Internetes vásárlás: <?php echo $order['order_id']; ?></ORDERHEAD_SUBJECT>
			<ORDERHEAD_VERIFIED>1</ORDERHEAD_VERIFIED>

	<?php
	
		//add item for shipping too if present
		$grossshipping = $order['order_shipping']+$order['shipping_tax'];
		if($grossshipping > 2.5) {
			$item = array(
				'order_item_id' => 'szktg',
				'product_name' => 'Szállítási költség - '.$shipment_method_name,
				'product_item_price' => $order['order_shipping'],
				'product_tax' => $order['shipping_tax'],
				'product_quantity' => 1,
			);
			$items[] = $item;
		}
		
		//add item for package too if present
		$grosspackage = $order['order_package'];
		if($grossshipping > 0) {
			$item = array(
				'order_item_id' => 'pckg',
				'product_name' => 'Csomagolási költség',
				'product_item_price' => $order['order_package'],
				'product_tax' => 0,
				'product_quantity' => 1,
			);
			$items[] = $item;
		}
	
		show_orderitems($items,$order); 
	?>
		</ORDER>
	<?php
}

function show_orderitems($items,$order)
{
	global $config;

	if(!$items)
		return;
	
	foreach($items as $item) {
		
		$unit = 'db';	
		$name = $item['product_name'];
		
		if (isset($item['product_ean'])) { // add sku to descritpion if available
			$name .= ' ('.$item['product_ean'].')';
		}
		
		if ($order['order_discount'] > 0.1) { //is there a product line % discount?
			$name .= ' '.(-$order['order_discount']).' Ft kedvezménnyel';
		}

		if ($order['order_shipping'] > 0.1) {
			$unit = '';
			$item['product_item_price'] = 100*$item['product_item_price']/(100+$item['product_tax']);
		}
		
		$vatcode = 'VAT'.number_format($item['product_tax'],2);
		$vatname = number_format($item['product_tax'],2);
			
	
?>
			<ORDERITEM>
				<ORDERITEM_CODE><?php echo $order['order_id'].'-'.$item['order_item_id']; ?></ORDERITEM_CODE>
				<ORDERITEM_NAME><?php echo he($name); ?></ORDERITEM_NAME>
				<ORDERITEM_QTY><?php echo $item['product_quantity']; ?></ORDERITEM_QTY>
				<ORDERITEM_UNIT><?php echo $unit; ?></ORDERITEM_UNIT>
				<ORDERITEM_LIST_PRICE><?php echo round($item['product_item_price'],2); ?></ORDERITEM_LIST_PRICE>
				<ORDERITEM_PRICE><?php echo round($item['product_item_price'],2); ?></ORDERITEM_PRICE>
				<ORDERITEM_VAT_CODE><?php echo $vatcode; ?></ORDERITEM_VAT_CODE>
				<ORDERITEM_VAT_NAME><?php echo $vatname; ?></ORDERITEM_VAT_NAME>
				<ORDERITEM_VAT_PERCENT><?php echo $item['product_tax']; ?></ORDERITEM_VAT_PERCENT>
				<ORDERITEM_TOTAL_GROSS><?php echo $item['product_item_price'];?></ORDERITEM_TOTAL_GROSS>
			</ORDERITEM>
<?php

				

	}
}


function he($s)
{
	//return htmlentities($s);
	return $s;
}

function show_error($error_str)
{
	echo($error_str);
	die();
}

function db_get_record($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_record(): [$q] " . mysql_error());
	return mysql_fetch_assoc($res);
}

function db_get_field($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_field(): [$q] " . mysql_error());
	$row = mysql_fetch_row($res);
	if($row == FALSE) return FALSE;
	return $row[0];
}

function db_get_records($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_records [$q] " . mysql_error());
	$ret_ary = array();
	while($ary = mysql_fetch_assoc($res))
	{
		$ret_ary[] = $ary;
	}
	if(count($ret_ary))
		return $ret_ary;
	return FALSE;
}

function db_get_map($q)
{
	$res = mysql_query($q);
	if(!$res)
		show_error("db_get_map [$q] " . mysql_error());
	$ret_ary = array();
	while($ary = mysql_fetch_row($res))
	{
		$ret_ary[$ary[0]] = $ary[1];
	}
	if(count($ret_ary))
		return $ret_ary;
	return FALSE;
}

function ary_to_utf8($ary)
{
	$res = array();
	foreach($ary as $k => $v)
	{
		if(!is_array($v))
		{
			$res[$k] = mb_convert_encoding($v, 'UTF-8', 'ISO-8859-2');
		}
		else
		{
			$res[$k] = $v;
		}
	}
	return $res;
}

?>
